/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.helper;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.ITraderStatus;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.quests.QuestSystem;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class ReputationHelper {
    public static final float MIN_REPUTATION = 0.0f;
    public static final float MAX_REPUTATION = 50.0f;

    public static void awardReputationForCompletedQuest(ITraderStatus status, Quest<?> quest) {
        float reputationAward = GunsRPG.config.quests.reputationAwardPerTier;
        ReputationHelper.addReputation(status, quest, tier -> Float.valueOf((float)tier.intValue() * reputationAward));
    }

    public static void takeReputationForFailedQuest(ITraderStatus status, Quest<?> quest) {
        float reputationLoss = GunsRPG.config.quests.reputationLossPerTier;
        ReputationHelper.addReputation(status, quest, tier -> Float.valueOf((float)tier.intValue() * -reputationLoss));
    }

    public static float clampWithinReputationLimits(float in) {
        return MathHelper.func_76131_a((float)in, (float)0.0f, (float)50.0f);
    }

    public static boolean isMaxedOut(float reputation) {
        return reputation >= 50.0f;
    }

    public static void awardPlayerForReputation(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)ModItems.GOLD_EGG_SHARD, 2);
        ModUtils.addItem(player, stack);
        GunsRPG.log.debug(QuestSystem.MARKER, "Added reputation award to {}", (Object)player.func_200200_C_().getString());
        player.func_145747_a((ITextComponent)new TranslationTextComponent("quest.reputation.award_given"), Util.field_240973_b_);
    }

    private static void addReputation(ITraderStatus status, Quest<?> quest, Function<Integer, Float> calculator) {
        int tier = quest.getRewardTier();
        float reputation = calculator.apply(tier).floatValue();
        status.addReputation(reputation);
    }

    private ReputationHelper() {
    }
}

